import java.util.*;

/** An instance is an array of bank accounts */
public class Bank {
    private BankAccount[] bank; // the accounts
    private int size;          // are in bank[0..size-1]
    
    /** A (reverse) iterator for bank accounts */
    private class BAIterator implements Iterator {
        private int n= size; // bank[0..n - 1] remains to be enumerated
        
        /** = "there is another account to enumerate" */
        public boolean hasNext() { return n > 0; }
        
        /** = the next item to be enumerated */
        public Object next() { n= n - 1; return bank[n]; }
        
        /** remove is not implemented */
        public void remove() {}
    }
    
    /** An iterator that enumerates bank accounts in reverse order */
    public Iterator iterator() { return new BAIterator(); }
}